// Rad_Cam.js | Radnen 2008 //

// - Nov 07 08 - Fixed: setCamera() infinity issue.
// - Aug 29 08 - Added: method to set camera position.
// - Jul 16 08 - Fixed: camera jumping bug.
// - Jul 16 08 - Added: waitForCamera();

function Camera()
{
	if (!this instanceof Camera) return new Camera();
	
	this.x = 0;
	this.xd = this.x;
	this.nx = 0;
	this.xoff = 0;
	this.y = 0;
	this.yd = this.y;
	this.ny = 0;
	this.yoff = 0;
	this.time = 0;
	this.input = null;
	this.msecs = 0;
	this.done = true;
}

Camera.prototype.attachCamera = function(name)
{
	this.input = name;
	this.x = GetPersonX(name);
	this.xd = this.x;
	this.y = GetPersonY(name);
	this.yd = this.y;
	if (IsMapEngineRunning()) this.setCamera(this.x, this.y);
}

Camera.prototype.detachCamera = function()
{
	this.input = null;
}

Camera.prototype.panCamera = function(x, y, msecs)
{
	this.input = null;
	this.msecs = msecs;
	this.nx = x; this.ny = y;
	this.time = GetTime();
	this.done = false;
}

Camera.prototype.update = function()
{	
	if (this.input != null && DoesPersonExist(this.input))
	{
		this.done = true;
		var px = GetPersonX(this.input);
		var py = GetPersonY(this.input);
		this.setCamera(px+this.xoff, py+this.yoff);
		this.y = GetCameraY(); this.x = GetCameraX();
		this.xd = this.x; this.yd = this.y;
	}
	else if (this.time + this.msecs > GetTime())
	{
		with(this)
		{
			if (nx > x) xd = x + (GetTime() - time) * (nx-x) / msecs;
			if (nx < x) xd = x - (GetTime() - time) * (x-nx) / msecs;
			if (ny > y) yd = y + (GetTime() - time) * (ny-y) / msecs;
			if (ny < y) yd = y - (GetTime() - time) * (y-ny) / msecs;
		}
		this.setCamera(this.xd+this.xoff, this.yd+this.yoff);
	}
	else
	{
		this.done = true;
		this.setCamera(this.nx+this.xoff, this.ny+this.yoff);
		this.y = GetCameraY(); this.x = GetCameraX();
	}
}

// This will pan the camera to a given person whose X and Y coordinates are used.
Camera.prototype.panCameraToPerson = function(name, msecs)
{
	var px = GetPersonX(name);
	var py = GetPersonY(name);
	this.panCamera(px, py, msecs);
	this.waitForCamera();
}

// This is an internal camera setting function, it makes the two set functions easier to use.
Camera.prototype.setCamera = function(x, y)
{
	// for some odd reason, getting the x/y of a destroyed entity brings up infinity.
	if (x != Number.POSITIVE_INFINITY || y != Number.POSITIVE_INFINITY)
	{
		SetCameraX(x);
		SetCameraY(y);
	}
}

// This is used to set the camera.
Camera.prototype.setXY = function(x, y)
{
	this.setCamera(x, y);
	this.x = x;
	this.y = y;
	this.xd = x;
	this.yd = y;
}

// This may be blocking code, yet it will still allow other events to occur
// Timed on the maps frame rate.
Camera.prototype.waitForCamera = function()
{
	var LastFr = GetFrameRate();
	SetFrameRate(GetMapEngineFrameRate());
	while(!this.done)
	{
		RenderMap();
		this.update();
		UpdateMapEngine();
		FlipScreen();
	}
	SetFrameRate(LastFr);
}

Camera.prototype.getX = function()
{
	return this.x + this.xoff;
}

Camera.prototype.getY = function()
{
	return this.y + this.yoff;
}